/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.client.camera.viewfinder;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.mortuusars.exposure.Config;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.client.animation.Animation;
import io.github.mortuusars.exposure.client.animation.EasingFunction;
import io.github.mortuusars.exposure.client.camera.viewfinder.Viewfinder;
import io.github.mortuusars.exposure.client.camera.viewfinder.ViewfinderCameraControlsScreen;
import io.github.mortuusars.exposure.client.util.GuiUtil;
import io.github.mortuusars.exposure.client.util.Minecrft;
import io.github.mortuusars.exposure.util.Rect2f;
import io.github.mortuusars.exposure.util.UnixTimestamp;
import io.github.mortuusars.exposure.world.camera.Camera;
import io.github.mortuusars.exposure.world.item.BrokenInterplanarProjectorItem;
import io.github.mortuusars.exposure.world.item.FilmRollItem;
import io.github.mortuusars.exposure.world.item.camera.Attachment;
import io.github.mortuusars.exposure.world.item.camera.CameraSettings;
import io.github.mortuusars.exposure.world.item.component.StoredItemStack;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_746;
import net.minecraft.class_7833;
import net.minecraft.class_9779;

public class ViewfinderOverlay {
    public static final class_2960 VIEWFINDER_TEXTURE = Exposure.resource("textures/gui/viewfinder/viewfinder.png");
    public static final class_2960 NO_FILM_ICON_TEXTURE = Exposure.resource("textures/gui/viewfinder/no_film.png");
    public static final class_2960 REMAINING_FRAMES_ICON_TEXTURE = Exposure.resource("textures/gui/viewfinder/remaining_frames.png");
    public static final class_2960 BSOD_SAD_FACE_TEXTURE = Exposure.resource("textures/gui/viewfinder/bsod_sad_face.png");
    public static final class_2960 BSOD_QR_CODE_TEXTURE = Exposure.resource("textures/gui/viewfinder/bsod_qr_code.png");
    protected final class_746 player = Minecrft.player();
    protected final Camera camera;
    protected final Viewfinder viewfinder;
    protected final Rect2f opening;
    protected final Animation scaleAnimation;
    protected final float initialScale;
    protected int backgroundColor;
    protected float scale;
    protected float bobX = 0.0f;
    protected float bobY = 0.0f;
    protected float attackAnim = 0.0f;
    protected float xRot;
    protected float yRot;
    protected float xRot0;
    protected float yRot0;
    protected boolean forceDrawShutterOnNextFrame;
    protected long forceDrawShutterUntil = -1L;

    public ViewfinderOverlay(Camera camera, Viewfinder viewfinder) {
        this.camera = camera;
        this.viewfinder = viewfinder;
        this.backgroundColor = Config.getColor(Config.Client.VIEWFINDER_BACKGROUND_COLOR);
        this.opening = new Rect2f(0.0f, 0.0f, 0.0f, 0.0f);
        this.recalculateOpening();
        this.scaleAnimation = new Animation(300, EasingFunction.EASE_OUT_EXPO);
        this.initialScale = 0.5f;
        this.scale = 0.5f;
        this.xRot = Minecrft.get().field_1773.method_19418().method_19329();
        this.yRot = Minecrft.get().field_1773.method_19418().method_19330();
        this.xRot0 = this.xRot;
        this.yRot0 = this.yRot;
    }

    public Rect2f getOpening() {
        return this.opening;
    }

    public float getScale() {
        return this.scale;
    }

    public void render(class_332 guiGraphics, class_9779 deltaTracker) {
        this.recalculateOpening();
        this.scale = class_3532.method_16439((float)((float)this.scaleAnimation.getValue()), (float)this.initialScale, (float)1.0f);
        if (!this.viewfinder.isLookingThrough() || Minecrft.options().field_1842 || this.camera.isEmpty()) {
            return;
        }
        int width = Minecrft.get().method_22683().method_4486();
        int height = Minecrft.get().method_22683().method_4502();
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_46416((float)width / 2.0f, (float)height / 2.0f, 0.0f);
        guiGraphics.method_51448().method_22905(this.scale, this.scale, this.scale);
        if (((Boolean)Minecrft.options().method_42448().method_41753()).booleanValue()) {
            this.bobView(guiGraphics.method_51448(), deltaTracker);
        }
        this.applyAttackAnimation(guiGraphics.method_51448(), deltaTracker);
        this.applyMovementDelay(guiGraphics.method_51448(), deltaTracker);
        guiGraphics.method_51448().method_46416((float)(-width) / 2.0f, (float)(-height) / 2.0f, 0.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.enableDepthTest();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiUtil.drawRect(guiGraphics, this.opening.x, this.opening.y, -9999.0f, this.opening.height, this.backgroundColor);
        GuiUtil.drawRect(guiGraphics, this.opening.x + this.opening.width, this.opening.y, 9999.0f, this.opening.height, this.backgroundColor);
        GuiUtil.drawRect(guiGraphics, -4999.0f, this.opening.y, 9999.0f, -9999.0f, this.backgroundColor);
        GuiUtil.drawRect(guiGraphics, -4999.0f, this.opening.y + this.opening.height, 9999.0f, 9999.0f, this.backgroundColor);
        boolean drawGuide = true;
        StoredItemStack filter = Attachment.FILTER.get(this.camera.getItemStack());
        class_1792 class_17922 = filter.getForReading().method_7909();
        if (class_17922 instanceof BrokenInterplanarProjectorItem) {
            BrokenInterplanarProjectorItem brokenInterplanarProjector = (BrokenInterplanarProjectorItem)class_17922;
            drawGuide = false;
            this.renderBSOD(guiGraphics, brokenInterplanarProjector, filter.getForReading());
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.enableDepthTest();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        this.drawShutter(guiGraphics);
        this.drawViewfinderTexture(guiGraphics);
        if (drawGuide) {
            class_2960 guideTexture = CameraSettings.COMPOSITION_GUIDE.getOrDefault(this.camera.getItemStack()).overlayTextureLocation();
            GuiUtil.blit(guideTexture, guiGraphics.method_51448(), this.opening, 0, 0, (int)this.opening.width, (int)this.opening.height, 0.0f);
        }
        if (!(Minecrft.get().field_1755 instanceof ViewfinderCameraControlsScreen)) {
            this.renderStatusIcons(guiGraphics.method_51448(), this.camera.getItemStack());
        }
        guiGraphics.method_51448().method_22909();
        RenderSystem.disableDepthTest();
    }

    protected void drawViewfinderTexture(class_332 guiGraphics) {
        GuiUtil.blit(VIEWFINDER_TEXTURE, guiGraphics.method_51448(), this.opening, 0, 0, (int)this.opening.width, (int)this.opening.height, 0.0f);
    }

    protected void drawShutter(class_332 guiGraphics) {
        if (this.camera.isShutterOpen() || this.forceDrawShutterOnNextFrame || this.forceDrawShutterUntil - System.currentTimeMillis() > 0L) {
            GuiUtil.drawRect(guiGraphics, this.opening, -98624229);
            this.forceDrawShutterOnNextFrame = false;
        }
    }

    public void startDrawingShutter() {
        this.forceDrawShutterOnNextFrame = true;
        this.forceDrawShutterUntil = UnixTimestamp.Milliseconds.now() + 100L;
    }

    protected void renderBSOD(class_332 guiGraphics, BrokenInterplanarProjectorItem item, class_1799 stack) {
        class_327 font = Minecrft.get().field_1772;
        int yCenter = (int)(this.opening.y + this.opening.height / 2.0f);
        Objects.requireNonNull(font);
        int margin = 9;
        int x = (int)(this.opening.x + this.opening.width * 0.125f);
        int y = yCenter;
        Objects.requireNonNull(font);
        int sadFaceSize = 9 * 5;
        guiGraphics.method_25290(BSOD_SAD_FACE_TEXTURE, x, y - sadFaceSize - margin, 0.0f, 0.0f, sadFaceSize, sadFaceSize, sadFaceSize, sadFaceSize);
        class_5250 message = class_2561.method_43471((String)"item.exposure.broken_interplanar_projector.viewfinder.message");
        List messageLines = font.method_1728((class_5348)message, (int)(this.opening.width * 0.75f));
        for (class_5481 line : messageLines) {
            guiGraphics.method_51430(font, line, x, y, -1, false);
            Objects.requireNonNull(font);
            y += 9;
        }
        y += margin;
        int qrCodeTextureSize = 41;
        int qrCodeSize = switch ((int)Minecrft.get().method_22683().method_4495()) {
            case 1 -> qrCodeTextureSize * 3;
            case 2 -> qrCodeTextureSize * 2;
            default -> qrCodeTextureSize;
        };
        guiGraphics.method_25290(BSOD_QR_CODE_TEXTURE, x, y, 0.0f, 0.0f, qrCodeSize, qrCodeSize, qrCodeSize, qrCodeSize);
        class_5250 errorCode = class_2561.method_43471((String)"item.exposure.broken_interplanar_projector.viewfinder.error_code");
        guiGraphics.method_51439(font, (class_2561)errorCode, x + qrCodeSize + margin, y, -1, false);
        Objects.requireNonNull(font);
        String code = item.getErrorCode(stack);
        guiGraphics.method_51433(font, code, x + qrCodeSize + margin, y += 9, -1, false);
    }

    public void bobView(class_4587 poseStack, class_9779 deltaTracker) {
        class_1297 class_12972 = Minecrft.get().method_1560();
        if (class_12972 instanceof class_1657) {
            class_1657 pl = (class_1657)class_12972;
            float walkDist = class_3532.method_16439((float)deltaTracker.method_60636(), (float)pl.field_6039, (float)pl.field_5973);
            float strength = class_3532.method_16439((float)deltaTracker.method_60636(), (float)pl.field_7505, (float)pl.field_7483);
            float x = class_3532.method_15374((float)(walkDist * (float)Math.PI)) * strength;
            float y = Math.abs(class_3532.method_15362((float)(walkDist * (float)Math.PI)) * strength);
            float delta = Math.min(deltaTracker.method_60636(), 1.0f);
            this.bobX = class_3532.method_16439((float)delta, (float)this.bobX, (float)x);
            this.bobY = class_3532.method_16439((float)delta, (float)this.bobY, (float)y);
            double guiScale = Minecrft.get().method_22683().method_4495();
            poseStack.method_22904((double)(this.bobX * 100.0f) / guiScale, (double)(this.bobY * 200.0f) / guiScale, 0.0);
            float scale = this.scale - this.bobY * 0.25f;
            poseStack.method_22905(scale, scale, scale);
        }
    }

    public void applyAttackAnimation(class_4587 poseStack, class_9779 deltaTracker) {
        float attack = this.player.field_6251;
        if (attack > 0.1f) {
            attack = 1.0f - attack;
        }
        float delta = Math.min(deltaTracker.method_60636(), 1.0f);
        this.attackAnim = class_3532.method_16439((float)delta, (float)this.attackAnim, (float)attack);
        poseStack.method_22905(1.0f - this.attackAnim * 0.1f, 1.0f - this.attackAnim * 0.2f, 1.0f - this.attackAnim * 0.1f);
        poseStack.method_22907(class_7833.field_40717.rotationDegrees(class_3532.method_16439((float)this.attackAnim, (float)0.0f, (float)5.0f)));
        double guiScale = Minecrft.get().method_22683().method_4495();
        poseStack.method_22904(0.0, 60.0 / guiScale * (double)this.attackAnim, 0.0);
    }

    public void applyMovementDelay(class_4587 poseStack, class_9779 deltaTracker) {
        float delta = Math.min(deltaTracker.method_60636() * 0.6f, 1.0f);
        this.xRot0 = class_3532.method_16439((float)delta, (float)this.xRot0, (float)this.xRot);
        this.yRot0 = class_3532.method_16439((float)delta, (float)this.yRot0, (float)this.yRot);
        this.xRot = Minecrft.get().field_1773.method_19418().method_19329();
        this.yRot = Minecrft.get().field_1773.method_19418().method_19330();
        double guiScale = Minecrft.get().method_22683().method_4495();
        double horizontalDelay = (double)(this.yRot - this.yRot0) / guiScale * 3.0;
        double verticalDelay = (double)(this.xRot - this.xRot0) / guiScale * 3.0;
        poseStack.method_22904(-horizontalDelay, -verticalDelay, 0.0);
    }

    protected void recalculateOpening() {
        int width = Minecrft.get().method_22683().method_4486();
        int height = Minecrft.get().method_22683().method_4502();
        float openingSize = Math.min(width, height);
        this.opening.x = ((float)width - openingSize) / 2.0f;
        this.opening.y = ((float)height - openingSize) / 2.0f;
        this.opening.width = openingSize;
        this.opening.height = openingSize;
    }

    protected void renderStatusIcons(class_4587 poseStack, class_1799 cameraStack) {
        FilmRollItem filmRollItem;
        class_1792 class_17922;
        class_1799 filmStack = Attachment.FILM.get(cameraStack).getForReading();
        if (filmStack.method_7960() || !((class_17922 = filmStack.method_7909()) instanceof FilmRollItem) || !(filmRollItem = (FilmRollItem)class_17922).canAddFrame(filmStack)) {
            this.renderNoFilmIcon(poseStack);
            return;
        }
        this.renderRemainingFramesIcon(poseStack, filmRollItem, filmStack);
    }

    protected void renderNoFilmIcon(class_4587 poseStack) {
        RenderSystem.setShaderTexture((int)0, (class_2960)NO_FILM_ICON_TEXTURE);
        int x = (int)(this.opening.x + this.opening.width / 2.0f - 12.0f);
        int y = (int)(this.opening.y + this.opening.height - 18.0f);
        GuiUtil.blit(poseStack, (float)x, (float)y, 23.0f, 18.0f, 0, 0, 23, 18, 0.0f);
    }

    protected void renderRemainingFramesIcon(class_4587 poseStack, FilmRollItem filmRollItem, class_1799 filmStack) {
        int maxFrames = filmRollItem.getMaxFrameCount(filmStack);
        int exposedFrames = filmRollItem.getStoredFramesCount(filmStack);
        int remainingFrames = Math.max(0, maxFrames - exposedFrames);
        if (maxFrames > 5 && remainingFrames <= 3) {
            RenderSystem.setShaderTexture((int)0, (class_2960)REMAINING_FRAMES_ICON_TEXTURE);
            float x = (int)(this.opening.x + this.opening.width / 2.0f - 17.0f);
            float y = (int)(this.opening.y + this.opening.height - 15.0f);
            int vOffset = (remainingFrames - 1) * 15;
            GuiUtil.blit(poseStack, x, y, 33.0f, 15.0f, 0, vOffset, 33, 45, 0.0f);
        }
    }
}

